from Components.Converter.Converter import Converter
from Components.Element import cached

class DEMetrixEventName(Converter, object):

	NAME = 0
	SHORT_DESCRIPTION = 1
	EXTENDED_DESCRIPTION = 2

	def __init__(self, type):
		Converter.__init__(self, type)

		converter_types = {
			"Name":					(self.NAME, self.getNameText),
			"ShortDescription":		(self.SHORT_DESCRIPTION, self.getShortDescriptionText),
			"ExtendedDescription":	(self.EXTENDED_DESCRIPTION, self.getExtendedDescriptionText)}

		self.converter_type = type in converter_types and type or "Name"
		print "[DEMetrixEventName] found type: %s" % self.converter_type

		self.type, self.funcText = converter_types[self.converter_type]

	@cached
	def getText(self):
		text = ""
		event = self.source.event
		if event:
			text = self.funcText(event)
		print "[DEMetrixEventName] (%s) text = %s" % (self.converter_type, text)
		return text

	text = property(getText)

	@cached
	def getBoolean(self):
		event = self.source.event
		if event:
			return True
		return False

	boolean = property(getBoolean) 

	def getNameText(self, event):
		text = event.getEventName().strip()
		if "Visibile gratis su digitale terrestre" in text:
			try:
				text = event.getShortDescription().title().strip()
			except:
				pass
		return text

	def getShortDescriptionText(self, event):
		text = event.getShortDescription().strip()
		return text

	def getExtendedDescriptionText(self, event):
		extended = event.getExtendedDescription().strip()
		short = event.getShortDescription().strip()
		return extended or short

	def changed(self, what):
		print "[DEMetrixEventName] (%s) suspended = %s" % (self.converter_type, str(self.suspended))
		print "[DEMetrixEventName] (%s) what[0]: %s" % (self.converter_type, str(what[0]))
		Converter.changed(self, what)
