from Components.Converter.Converter import Converter
from Components.Element import cached
from enigma import iDVBFrontend

frontend_types = {
	iDVBFrontend.feSatellite:		"DVB-S",
	iDVBFrontend.feSatellite2:		"DVB-S",
	iDVBFrontend.feTerrestrial:		"DVB-T",
	iDVBFrontend.feTerrestrial2:	"DVB-T",
	iDVBFrontend.feCable:			"DVB-C",
	None:							""}

class DEMetrixFrontendInfo(Converter, object):

	BER = 0
	SNR = 1
	AGC = 2
	LOCK = 3
	SNRdB = 4
	SLOT_NUMBER = 5
	TUNER_TYPE = 6

	def __init__(self, type):
		Converter.__init__(self, type)

		converter_types = {
			"BER":			(self.BER, self.getBERText, self.getBERValue),
			"SNR":			(self.SNR, self.getSNRText, self.getSNRValue),
			"AGC":			(self.AGC, self.getAGCText, self.getAGCValue),
			"LOCK":			(self.LOCK, self.getEmptyText, self.getZeroValue),
			"SNRdB":		(self.SNRdB, self.getSNRdBText, self.getZeroValue),
			"SlotNumber":	(self.SLOT_NUMBER, self.getEmptyText, self.getSlotNumberValue),
			"TunerType":	(self.TUNER_TYPE, self.getTunerTypeText, self.getTunerTypeValue)}

		self.converter_type = type in converter_types and type or "TunerType"
		print "[DEMetrixFrontendInfo] found type: %s" % self.converter_type

		self.type, self.funcText, self.funcValue = converter_types[self.converter_type]

	@cached
	def getText(self):
		text = self.funcText()
		print "[DEMetrixFrontendInfo] (%s) text = %s" % (self.converter_type, text)
		return text

	text = property(getText)

	@cached
	def getValue(self):
		return self.funcValue()

	range = 65536
	value = property(getValue)

	@cached
	def getBoolean(self):
		return self.funcBoolean()

	boolean = property(getBoolean) 

	def getBERText(self):
		ber = self.source.ber
		if ber is not None:
			return "BER: %d" % ber
		return "BER: N/A"

	def getSNRText(self):
		snr = self.source.snr
		if snr is not None:
			return "SNR: %d%%" % (snr * 100 / 65536)
		return "SNR: N/A"

	def getAGCText(self):
		agc = self.source.agc
		if agc is not None:
			return "AGC: %d%%" % (agc * 100 / 65536)
		return "AGC: N/A"

	def getSNRdBText(self):
		snr_db = self.source.snr_db
		snr = self.source.snr
		if snr_db is not None:
			return "SNRdB: %3.02f dB" % (snr_db / 100.0)
		elif snr is not None:
			return "SNR: %d%%" % (snr * 100 / 65536)
		return "SNRdB: N/A"

	def getTunerTypeText(self):
		frontend_type = self.source.frontend_type
		return frontend_types[frontend_type]

	def getEmptyText(self):
		return ""

	def getBERValue(self):
		ber = self.source.ber
		if ber < self.range:
			return ber or 0
		return self.range

	def getSNRValue(self):
		snr = self.source.snr
		return snr or 0

	def getAGCValue(self):
		agc = self.source.agc
		return agc or 0

	def getSlotNumberValue(self):
		slot_number = self.source.slot_number
		return slot_number is None and -1 or slot_number

	def getTunerTypeValue(self):
		frontend_type = self.source.frontend_type
		return frontend_type is None and -1 or frontend_type

	def getZeroValue(self):
		return 0



	def changed(self, what):
		print "[DEMetrixFrontendInfo] (%s) suspended = %s" % (self.converter_type, str(self.suspended))
		print "[DEMetrixFrontendInfo] (%s) what[0]: %s" % (self.converter_type, str(what[0]))
		Converter.changed(self, what)




	@cached
	def getBool(self):
		if self.type == self.LOCK:
			lock = self.source.lock
			if lock is None:
				lock = False
			return lock
		elif self.type == self.BER:
			ber = self.source.ber
			if ber is None:
				ber = 0
			return ber > 0
		return False

	boolean = property(getBool)
