from Components.Converter.Converter import Converter
from Components.Element import cached
from enigma import iServiceInformation, iPlayableService, iPlayableServicePtr, eServiceReference
from ServiceReference import ServiceReference 

class DEMetrixServiceName(Converter, object):

	NAME = 0
	PROVIDER = 1
	REFERENCE_FOR_PICON = 2
	REFERENCE_FOR_LABEL = 3

	def __init__(self, type):
		Converter.__init__(self, type)

		converter_types = {
			"Name":					(self.NAME, self.getNameText),
			"Provider":				(self.PROVIDER, self.getProviderText),
			"ReferenceForPicon":	(self.REFERENCE_FOR_PICON, self.getReferenceForPiconText),
			"ReferenceForLabel":	(self.REFERENCE_FOR_LABEL, self.getReferenceForLabelText)}

		self.converter_type = type in converter_types and type or "Name"
		print "[DEMetrixServiceName] found type: %s" % self.converter_type

		self.type, self.funcText = converter_types[self.converter_type]

	@cached
	def getText(self):
		service = self.source.service
		if isinstance(service, iPlayableServicePtr):
			info = service and service.info()
			service = None
		else: # reference
			info = service and self.source.info
		if info is None:
			print "[DEMetrixServiceName] (%s) service.info() or self.source.info not available" % self.converter_type
			return ""
		text = self.funcText(info, service)
		print "[DEMetrixServiceName] (%s) text = %s" % (self.converter_type, text)
		return text

	text = property(getText)

	@cached
	def getBoolean(self):
		event = self.source.event
		if event:
			return True
		return False

	boolean = property(getBoolean)

	def getNameText(self, info, service):
		path = service and service.getPath()
		if path and path[0] == "/":
			newservice = ServiceReference(info.getInfoString(service, iServiceInformation.sServiceref))
			name = newservice and newservice.getServiceName() or ""
		else:
			name = service and info.getName(service)
		if name is None:
			print "[DEMetrixServiceName] (%s) service not available" % self.converter_type
			name = info.getName()
		return name.replace("\xc2\x86", "").replace("\xc2\x87", "")

	def getProviderText(self, info, service):
		return "Provider"

	def getReferenceForPiconText(self, info, service):
		if service:
			reference = service.toString()
		else:
			reference = info.getInfoString(iServiceInformation.sServiceref)
		reference = self.getReferencePath(reference)
		return reference

	def getReferenceForLabelText(self, info, service):
		text = "Reference not available"
		reference = self.getReferenceForPiconText(info, service)
		if reference:
			if service and (service.flags & eServiceReference.isMarker == eServiceReference.isMarker):
				text = "Reference not available (Marker)"
			elif service and (service.flags & eServiceReference.flagDirectory == eServiceReference.flagDirectory):
				text = "Reference not available (Folder)"
			else:
				tmp = reference.split(":", 10)[:10]
				text = "Reference: " + ":".join(tmp)
		return text

	def getReferencePath(self, reference):
		path = reference and eServiceReference(reference).getPath()
		if path and path[0] == "/":
			try:
				meta = open("%s.meta" % path, "r")
				reference = meta.readline().strip()
				meta.close()
			except:
				pass
		return reference

	def changed(self, what):
		print "[DEMetrixServiceName] (%s) suspended = %s" % (self.converter_type, str(self.suspended))
		if what[0] != self.CHANGED_SPECIFIC or what[1] in (iPlayableService.evStart,):
			print "[DEMetrixServiceName] (%s) what[0]: %s" % (self.converter_type, str(what[0]))
			Converter.changed(self, what)
