from Components.Converter.Converter import Converter
from Components.Element import cached
from enigma import eServiceReference

class MetrixEventName(Converter, object):

	NAME = 0
	SHORT_DESCRIPTION = 1
	EXTENDED_DESCRIPTION = 2
	FULL_DESCRIPTION = 3
	NOT_SERVICE = 4
	
	def __init__(self, type):
		Converter.__init__(self, type)

		self.type = {	"Name": 				self.NAME,
						"Description":			self.SHORT_DESCRIPTION,
						"ExtendedDescription":	self.EXTENDED_DESCRIPTION,
						"FullDescription":		self.FULL_DESCRIPTION,
						"NotService":			self.NOT_SERVICE,
					}[type]

	@cached
	def getText(self):
		event = self.source.event
		if event is None:
			try:
				service = self.source.service
				marker = (service.flags & eServiceReference.isMarker == eServiceReference.isMarker)
				bouquet = (service.flags & eServiceReference.flagDirectory == eServiceReference.flagDirectory) 
			except:
				marker = bouquet = False
			if marker or bouquet:
				return ""
			if self.type == self.NAME:
				return "Nessuna informazione"
			else: 
				return "Nessuna informazione disponibile per l'evento corrente."
			return ""
		txt = ""
		if self.type == self.NAME:
			if event.getEventName()[:31] == "Visibile gratis su digitale terrestre":
		  		txt = event.getShortDescription().title()
		  	else:
				txt = event.getEventName()
		elif self.type == self.SHORT_DESCRIPTION:
			txt = event.getShortDescription()
		elif self.type == self.EXTENDED_DESCRIPTION:
			txt = event.getExtendedDescription()
		elif self.type == self.FULL_DESCRIPTION:
			txt = event.getShortDescription().strip()
			txt = txt + "\n" + event.getExtendedDescription().strip()
		return txt.strip()		

	text = property(getText)

	@cached
	def getBoolean(self):
		if self.type == self.NOT_SERVICE:
			try:
				service = self.source.service
				marker = (service.flags & eServiceReference.isMarker == eServiceReference.isMarker)
				bouquet = (service.flags & eServiceReference.flagDirectory == eServiceReference.flagDirectory) 
			except:
				return True
			return marker or bouquet
		return False

	boolean = property(getBoolean)

	def changed(self, what):
		Converter.changed(self, what) 