from Components.Converter.Converter import Converter
from enigma import iServiceInformation, iPlayableService
from Components.Element import cached

class MetrixServiceInfo(Converter, object):

	HAS_SUBTITLES = 0
	HAS_TELETEXT = 1
	IS_CRYPTED = 2
	IS_HD = 3
	IS_MULTICHANNEL = 4
	IS_WIDESCREEN = 5
	SUBSERVICES_AVAILABLE = 6
	FRAMERATE = 7
	TRANSFERBPS = 8
	XRES = 9
	YRES = 10
	XRESYRESFRAMERATE = 11

	def __init__(self, type):
		Converter.__init__(self, type)

		self.type = {	"HasSubtitles": 		self.HAS_SUBTITLES,
						"HasTelext":			self.HAS_TELETEXT,
						"IsCrypted":			self.IS_CRYPTED,
						"IsHD":					self.IS_HD,
						"IsMultichannel":		self.IS_MULTICHANNEL,
						"IsWidescreen":			self.IS_WIDESCREEN,
						"SubservicesAvailable":	self.SUBSERVICES_AVAILABLE,
						"Framerate":			self.FRAMERATE,
						"TransferBPS":			self.TRANSFERBPS,
						"VideoWidth":			self.XRES,
						"VideoHeight":			self.YRES,
						"WidthHeightFramerate":	self.XRESYRESFRAMERATE,
					}[type]

	def getServiceInfoString(self, info, what, convert = lambda x: "%d" % x):
		v = info.getInfo(what)
		if v == -1:
			return "N/A"
		if v == -2:
			return info.getInfoString(what)
		return convert(v)

	@cached
	def getBoolean(self):
		service = self.source.service
		if self.type == self.HAS_SUBTITLES:
			#subtitle = service and service.subtitle()
			#if subtitle and subtitle.getSubtitleList():
				#return True
			return False
		info = service and service.info()
		if not info:
			return False
		if self.type == self.HAS_TELETEXT:
			tpid = info.getInfo(iServiceInformation.sTXTPID)
			return tpid != -1
		elif self.type == self.IS_CRYPTED:
			return info.getInfo(iServiceInformation.sIsCrypted) == 1
		elif self.type == self.IS_HD:
			return info.getInfo(iServiceInformation.sVideoWidth) > 720
		elif self.type == self.IS_MULTICHANNEL:
			audio = service.audioTracks()
			if audio:
				n = audio.getNumberOfTracks()
				idx = 0
				while idx < n:
					i = audio.getTrackInfo(idx)
					description = i.getDescription();
					if "AC3" in description or "DTS" in description:
						return True
					idx += 1
			return False
		elif self.type == self.IS_WIDESCREEN:
			return info.getInfo(iServiceInformation.sAspect) in (3, 4, 7, 8, 0xB, 0xC, 0xF, 0x10)
		elif self.type == self.SUBSERVICES_AVAILABLE:
			subservices = service.subServices()
			return subservices and subservices.getNumberOfSubservices() > 0
		return False

	boolean = property(getBoolean)
	
	@cached
	def getText(self):
		service = self.source.service
		info = service and service.info()
		if not info:
			return ""
		if self.type == self.FRAMERATE:
			return self.getServiceInfoString(info, iServiceInformation.sFrameRate, lambda x: "%d fps" % ((x+500)/1000))
		elif self.type == self.TRANSFERBPS:
			return self.getServiceInfoString(info, iServiceInformation.sTransferBPS, lambda x: "%d kB/s" % (x/1024))
		elif self.type == self.XRES:
			return self.getServiceInfoString(info, iServiceInformation.sVideoWidth)
		elif self.type == self.YRES:
			return self.getServiceInfoString(info, iServiceInformation.sVideoHeight)
		elif self.type == self.XRESYRESFRAMERATE:
			width = self.getServiceInfoString(info, iServiceInformation.sVideoWidth)
			height = self.getServiceInfoString(info, iServiceInformation.sVideoHeight)
			frate = self.getServiceInfoString(info, iServiceInformation.sFrameRate, lambda x: "%d fps" % ((x+500)/1000))
			return "Videosize: " + width + " x " + height + " - Framerate: " + frate
		return ""

	text = property(getText)

	def changed(self, what):
		Converter.changed(self, what)