# -*- coding: utf-8 -*-

from Components.Converter.Converter import Converter
from Components.Element import cached

class mtxConditionalShowHide(Converter, object):
	def __init__(self, argstr):
		Converter.__init__(self, argstr)

		self.__text = ""

		args = argstr.split(",")
		self.invert = "Invert" in args
		del args

	def connectDownstream(self, downstream):
		Converter.connectDownstream(self, downstream)
		vis = self.calcVisibility()
		downstream.visible = vis

	@cached
	def getText(self):
		return self.__text

	text = property(getText)

	def calcVisibility(self):
		bool = self.source.boolean
		text = self.source.text
		self.__text = text
		if bool is None:
			return True
		bool ^= self.invert
		return bool

	def changed(self, what):
		vis = self.calcVisibility()
		for downstream_element in self.downstream_elements:
			downstream_element.visible = vis
		Converter.changed(self, what)
