# -*- coding: utf-8 -*-

from Components.Converter.Converter import Converter
from Components.Element import cached

from time import time

class mtxEventTime(Converter, object):

	STARTTIME = 0
	ENDTIME = 1
	DURATION = 2
	REMAINING = 3
	PROGRESS = 4

	def __init__(self, type):
		Converter.__init__(self, type)

		converter_types = {	"StartTime": (self.STARTTIME, self.getStartTime,	 self.getNone,		 self.getTrue),
							"EndTime":	 (self.ENDTIME,	  self.getEndTime,		 self.getNone,		 self.getTrue),
							"Duration":	 (self.DURATION,  self.getDurationTime,	 self.getNone,		 self.getTrue),
							"Remaining": (self.REMAINING, self.getRemainingTime, self.getNone,		 self.getRemainingToBoolean),
							"Progress":	 (self.PROGRESS,  self.getNone,			 self.ProgressValue, self.getTrue)
							}

		self.converter_type = type in converter_types and type or "StartTime"
		print "[mtxEventTime] found type: %s" % self.converter_type

		self.type, self.funcTime, self.funcValue, self.funcBoolean = converter_types[self.converter_type]

	@cached
	def getTime(self):
		event = self.source.event
		if event:
			return self.funcTime(event)
		print "[mtxEventTime] (%s) self.source.event not available" % self.converter_type
		return None

	time = property(getTime)

	@cached
	def getValue(self):
		event = self.source.event
		if event:
			return self.funcValue(event)
		print "[mtxEventTime] (%s) self.source.event not available" % self.converter_type
		return None

	range = 1000
	value = property(getValue)

	@cached
	def getBoolean(self):
		event = self.source.event
		if event:
			return self.funcBoolean(event)
		return False

	boolean = property(getBoolean)

	def getNone(self, event):
		return None

	def getStartTime(self, event):
		return event.getBeginTime()

	def getEndTime(self, event):
		return event.getBeginTime() + event.getDuration()

	def getDurationTime(self, event):
		return event.getDuration()

	def getRemainingTime(self, event):
		now = int(time())
		begintime = event.getBeginTime()
		duration = event.getDuration()
		endtime = begintime + duration
		if begintime <= now <= endtime:
			return (duration, endtime - now)
		else:
			return (duration, None) 

	def ProgressValue(self, event):
		now = int(time())
		begintime = event.getBeginTime()
		duration = event.getDuration()
		endtime = begintime + duration
		if begintime <= now <= endtime and duration > 0:
			return (now - begintime) * 1000 / duration
		else:
			return None

	def getTrue(self, event):
		return True

	def getRemainingToBoolean(self, event):
		now = int(time())
		begintime = event.getBeginTime()
		duration = event.getDuration()
		endtime = begintime + duration
		return begintime <= now <= endtime and duration > 0

	def changed(self, what):
		print "[mtxEventTime] (%s) suspended = %s" % (self.converter_type, str(self.suspended))
		if self.type == self.PROGRESS and len(self.downstream_elements):
			if not self.source.event and self.downstream_elements[0].visible:
				self.downstream_elements[0].visible = False
			elif self.source.event and not self.downstream_elements[0].visible:
				self.downstream_elements[0].visible = True
		Converter.changed(self, what)
