# -*- coding: utf-8 -*-

from Components.Converter.Converter import Converter
from Components.Element import cached

class mtxLabelToBoolean(Converter, object):
	def __init__(self, argstr):
		Converter.__init__(self, argstr)

		self.__text = ""

	def connectDownstream(self, downstream):
		Converter.connectDownstream(self, downstream)
		self.__text = self.source.text

	@cached
	def getText(self):
		return self.__text

	text = property(getText)

	@cached
	def getBoolean(self):
		text = self.source.text.strip()
		bool = text != ""
		self.__text = text
		return bool

	boolean = property(getBoolean)

	def changed(self, what):
		Converter.changed(self, what)
