# -*- coding: utf-8 -*-

from Components.config import config
from Components.Converter.Converter import Converter
from Components.Element import cached
from enigma import iServiceInformation
from ServiceReference import ServiceReference

from os import stat as os_stat

units = [(1024 ** 5, "PB"),
		 (1024 ** 4, "TB"),
		 (1024 ** 3, "GB"),
		 (1024 ** 2, "MB"),
		 (1024 ** 1, "KB"),
		 (1024 ** 0, "Bytes")
		 ]

class mtxMovieInfo(Converter, object):

	MOVIE_SERVICE_NAME = 0
	MOVIE_MOVIE_NAME = 1
	MOVIE_EVENT_NAME = 2
	MOVIE_META_DESCRIPTION = 3
	MOVIE_SHORT_DESCRIPTION = 4
	MOVIE_EXTENDED_DESCRIPTION = 5
	MOVIE_FILESIZE = 6

	def __init__(self, type):
		Converter.__init__(self, type)

		converter_types = {	"ServiceName":		   (self.MOVIE_SERVICE_NAME,		 self.serviceNameText),
							"MovieName":		   (self.MOVIE_MOVIE_NAME,			 self.movieNameText),
							"EventName":		   (self.MOVIE_EVENT_NAME,			 self.eventNameText),
							"MetaDescription":	   (self.MOVIE_META_DESCRIPTION,	 self.metaDescriptionText),
							"ShortDescription":	   (self.MOVIE_SHORT_DESCRIPTION,	 self.shortDescriptionText),
							"ExtendedDescription": (self.MOVIE_EXTENDED_DESCRIPTION, self.extendedDescriptionText),
							"FileSize":			   (self.MOVIE_FILESIZE,			 self.fileSizeText)
							}

		self.converter_type = type in converter_types and type or "ServiceName"
		print "[mtxMovieInfo] found type: %s" % self.converter_type

		self.type, self.funcText = converter_types[self.converter_type]

	@cached
	def getText(self):
		text = ""
		service = self.source.service
		info = self.source.info
		if info and service:
			event = self.source.event
			text = self.funcText(info, service, event)
		print "[mtxMovieInfo] (%s) text = %s" % (self.converter_type, text)
		return text

	text = property(getText)

	@cached
	def getBoolean(self):
		return config.movielist.description.value == 1

	boolean = property(getBoolean)

	def serviceNameText(self, info, service, event):
		reference = info.getInfoString(service, iServiceInformation.sServiceref)
		return ServiceReference(reference).getServiceName()

	def movieNameText(self, info, service, event):
		reference = info.getInfoString(service, iServiceInformation.sServiceref)
		name = ServiceReference(reference).getServiceName()
		if name or event:
			return ""
		path = service.getPath()
		if path:
			try:
				fullname, ext = path.rsplit(".", 1)
				print "[mtxMovieInfo] Fullname:", fullname
				print "[mtxMovieInfo] Ext:", ext
				name = fullname.rsplit("/", 1)[1].replace(".", " ").replace("_", " ").strip()
				ext = ext and ("(" + ext.upper() + ")") or ""
				return ext + "\n\n" + name
			except:
				pass
		return ""

	def eventNameText(self, info, service, event):
		if event:
			return event.getEventName()
		return ""

	def metaDescriptionText(self, info, service, event):
		return info.getInfoString(service, iServiceInformation.sDescription).strip()

	def shortDescriptionText(self, info, service, event):
		short = info.getInfoString(service, iServiceInformation.sDescription)
		if not short and event:
			short = event.getShortDescription()
		return short.strip()

	def extendedDescriptionText(self, info, service, event):
		meta = info.getInfoString(service, iServiceInformation.sDescription)
		short = ""
		extended = ""
		if event:
			short = event.getShortDescription()
			extended = event.getExtendedDescription()
		return (extended.strip() or short.strip()) or meta.strip()

	def fileSizeText(self, info, service, event):
		text = _("File not found")
		#filesize = info.getInfoObject(service, iServiceInformation.sFileSize)
		path = service.getPath()
		if path:
			filesize = os_stat(path)[6]
			if filesize < 0:
				text = _("File size not available")
				return text
			if filesize == 0:
				text = _("The file is empty")
				return text
			for factor, suffix in units:
				if filesize >= factor:
					break
			if suffix in ("Bytes", "KB", "MB"):
				text = _("File size: %d %s") % (filesize / factor, suffix)
			else:
				text = _("File size: %.2f %s") % (float(filesize) / factor, suffix)
		return text

	def changed(self, what):
		print "[mtxMovieInfo] (%s) suspended = %s" % (self.converter_type, str(self.suspended))
		print "[mtxMovieInfo] (%s) what[0]: %s" % (self.converter_type, str(what[0]))
		Converter.changed(self, what)
