# -*- coding: utf-8 -*-

from Components.Converter.Converter import Converter
from Components.Converter.Poll import Poll
from Components.Element import cached
from enigma import iPlayableService

import time

class mtxServicePosition(Poll, Converter, object):

	TYPE_LENGTH = 0
	TYPE_POSITION = 1
	TYPE_REMAINING = 2
	TYPE_ENDTIME = 3
	TYPE_GAUGE = 4

	def __init__(self, type):
		Poll.__init__(self)
		Converter.__init__(self, type)

		converter_types = {	"Length":	 (self.TYPE_LENGTH,	   self.getLengthText,	  True, 2000),
							"Position":	 (self.TYPE_POSITION,  self.getPositionText,  True, 1000),
							"Remaining": (self.TYPE_REMAINING, self.getRemainingText, True, 1000),
							"EndTime":	 (self.TYPE_ENDTIME,   self.getEndTimeText,	  True, 1000),
							"Gauge":	 (self.TYPE_GAUGE,	   self.getEmptyText,	  True, 1000)
							}

		self.converter_type = type in converter_types and type or "Length"
		print "[mtxServicePosition] found type: %s" % self.converter_type

		self.type, self.funcText, pollenabled, self.poll_interval = converter_types[self.converter_type]
		self.poll_enabled = pollenabled

	def connect(self, upstream):
		print "[mtxServicePosition] (%s) Connect" % self.converter_type
		print "[mtxServicePosition] (%s) suspended = %s" % (self.converter_type, str(self.suspended))
		Poll.doSuspend(self, self.suspended)
		Converter.connect(self, upstream)

	def getSeek(self):
		service = self.source.service
		return service and service.seek() or None

	@cached
	def getText(self):
		seek = self.getSeek()
		if seek is None:
			print "[mtxServicePosition] (%s) getSeek() returned None" % self.converter_type
			return ""
		text = self.funcText(seek)
		print "[mtxServicePosition] (%s) text = %s" % (self.converter_type, text)
		return text

	text = property(getText)

	@cached
	def getValue(self):
		seek = self.getSeek()
		if seek is None:
			print "[mtxServicePosition] (%s) getSeek() returned None" % self.converter_type
			return None
		position = seek.getPlayPosition()
		if position[0]:
			positionvalue = 0
		else:
			positionvalue = position[1]
		length = seek.getLength()
		if length[0]:
			lengthvalue = 0
		else:
			lengthvalue = length[1]
		if lengthvalue <= 0:
			return None
		value = positionvalue * 10000 / lengthvalue
		print "[mtxServicePosition] (%s) value = %d" % (self.converter_type, value)
		return value

	range = 10000
	value = property(getValue)

	def valueToText(self, value):
		value /= 90000
		sign = ""
		if value < 0:
			value = -value
			sign = "-"
		return sign + "%d:%02d" % (value/60, value%60)

	def getLengthText(self, seek):
		length = seek.getLength()
		print "[mtxServicePosition] (%s) Length = %s" % (self.converter_type, str(length))
		if length[0]:
			lengthvalue = 0
		else:
			lengthvalue = length[1]
		return self.valueToText(lengthvalue)

	def getPositionText(self, seek):
		position = seek.getPlayPosition()
		print "[mtxServicePosition] (%s) Position = %s" % (self.converter_type, str(position))
		if position[0]:
			positionvalue = 0
		else:
			positionvalue = position[1]
		return self.valueToText(positionvalue)

	def getRemainingText(self, seek):
		length = seek.getLength()
		if length[0]:
			lengthvalue = 0
		else:
			lengthvalue = length[1]
		position = seek.getPlayPosition()
		if position[0]:
			positionvalue = 0
		else:
			positionvalue = position[1]
		remainingvalue = lengthvalue - positionvalue
		print "[mtxServicePosition] (%s) Remaining = %s" % (self.converter_type, str(remainingvalue))
		return self.valueToText(remainingvalue)

	def getEndTimeText(self, seek):
		return "EndTime"

	def getEmptyText(self, seek):
		return ""

	def changed(self, what):
		print "[mtxServicePosition] (%s) suspended = %s" % (self.converter_type, str(self.suspended))
		print "[mtxServicePosition] (%s) what[0]: %s" % (self.converter_type, str(what[0]))
		time_refresh = what[0] == self.CHANGED_POLL or (what[0] == self.CHANGED_SPECIFIC and what[1] in (iPlayableService.evCuesheetChanged,)) or what[0] == self.CHANGED_ANIMATED
		if time_refresh:
			Converter.changed(self, what)
