# -*- coding: utf-8 -*-

from Components.Converter.Converter import Converter
from Components.Element import cached

class mtxStringListSelectionToBoolean(Converter, object):
	def __init__(self, argstr):
		Converter.__init__(self, argstr)

		self.__text = ""

		args = argstr.split(",")
		self.element_comparetext = ""
		if args[0].isdigit():
			self.element_index = int(args[0])
		else:
			self.element_index = 0
			self.element_comparetext = args[0]
		if len(args) > 1:
			self.element_comparetext = args[1]
		del args

	def selChanged(self):
		self.downstream_elements.changed((self.CHANGED_ALL,))

	@cached
	def getText(self):
		return self.__text

	text = property(getText)

	@cached
	def getBoolean(self):
		cur = self.source.current
		if cur and len(cur):
			text = str(cur[self.element_index])
			self.__text = text
			return self.element_comparetext in text
		self.__text = ""
		return False

	boolean = property(getBoolean)

	def entry_changed(self, index):
		pass

	def changed(self, what):
		if what[0] == self.CHANGED_DEFAULT:
			self.source.onSelectionChanged.append(self.selChanged)
		Converter.changed(self, what)
