# -*- coding: utf-8 -*-

from Components.Converter.Converter import Converter
from Components.Element import cached

class mtxStringListSelectionToLabel(Converter, object):
	def __init__(self, argstr):
		Converter.__init__(self, argstr)

		if argstr.isdigit():
			self.element_index = int(argstr)
		else:
			self.element_index = 0

	def selChanged(self):
		self.downstream_elements.changed((self.CHANGED_ALL,))

	@cached
	def getText(self):
		cur = self.source.current
		if cur and len(cur):
			return cur[self.element_index]
		return ""

	text = property(getText)

	def entry_changed(self, index):
		pass

	def changed(self, what):
		if what[0] == self.CHANGED_DEFAULT:
			self.source.onSelectionChanged.append(self.selChanged)
		Converter.changed(self, what)
