#######################################################################
#
#    Converter for Enigma2
#    Coded by shamann (c)2015
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#######################################################################

from Renderer import Renderer
from enigma import ePixmap, ePoint
from Tools.Directories import fileExists, SCOPE_SKIN_IMAGE, SCOPE_CURRENT_SKIN, resolveFilename
from enigma import eServiceReference, eServiceCenter
from Components.config import config

class MetrixXPiconChannelMove(Renderer):

	searchPaths = (	'/media/hdd/XPicons/%s/',
					'/media/usb/XPicons/%s/',
					'/media/usb1/XPicons/%s/',
					'/media/card/XPicons/%s/',
					'/media/cf/XPicons/%s/',
					'/usr/share/enigma2/XPicons/%s/' ) 

	def __init__(self):
		Renderer.__init__(self)

		self.path = "picon"
		self.pos1 = (0,0)
		self.pos2 = (0,0)
		self.nameCache = { }
		self.pngname = ""

	def applySkin(self, desktop, parent):
		attribs = [ ]
		for (attrib, value) in self.skinAttributes:
			if attrib == "path":
				self.path = value
			elif attrib == "position":
				position = value.split(',')
				self.pos1 = (int(position[0]),int(position[1]))
			elif attrib == "move":
				move = value.split(',')
				self.pos2 = (int(move[0]),int(move[1]))
			else:
				attribs.append((attrib,value))
		self.skinAttributes = attribs
		return Renderer.applySkin(self, desktop, parent) 

	GUI_WIDGET = ePixmap

	def postWidgetCreate(self, instance):
		instance.setShowHideAnimation("zoom_and_fade")

	def changed(self, what):
		if self.instance:
			if what[0] != self.CHANGED_CLEAR:
				pngname = self.findPiconName(what)
				if self.pngname != pngname:
					self.pngname = pngname
				if self.source.event is None:
					self.instance.hide()
					self.instance.move(ePoint(*self.pos2))
					self.instance.setPixmapFromFile(self.pngname)
					self.instance.show()
				else:
					self.instance.hide()
					self.instance.move(ePoint(*self.pos1))
					self.instance.setPixmapFromFile(self.pngname)
					self.instance.show()


	def findPiconName(self, what):
		pngname = ""
		service = self.source.service
		marker = (service.flags & eServiceReference.isMarker == eServiceReference.isMarker)
		bouquet = (service.flags & eServiceReference.flagDirectory == eServiceReference.flagDirectory)
		if marker:
			pngname = self.nameCache.get("marker", "")
			if pngname == "":
				tmp = resolveFilename(SCOPE_CURRENT_SKIN, "marker.png")
				if fileExists(tmp):
					pngname = tmp
				else:
					pngname = resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/picon_default.png")
				self.nameCache["marker"] = pngname
		elif bouquet:
			pngname = self.nameCache.get("bouquet", "")
			if pngname == "":
				tmp = resolveFilename(SCOPE_CURRENT_SKIN, "bouquet.png")
				if fileExists(tmp):
					pngname = tmp
				else:
					pngname = resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/picon_default.png")
				self.nameCache["bouquet"] = pngname
		else:
			sname = service.toString()
			if sname is not None and sname != "":
				tmp = self.alternative(sname).split(':', 10)[:10]
				if len(tmp) > 0 and tmp[0] == '4097':
					tmp[0] = '1'
				sname = '_'.join(tmp)
				pngname = self.nameCache.get(sname, "")
				if pngname == "":
					pngname = self.findPicon(sname)
					if pngname != "":
						self.nameCache[sname] = pngname
		if pngname == "":
			pngname = self.nameCache.get("default", "")
			if pngname == "":
				pngname = self.findPicon("picon_default")
				if pngname == "":
					tmp = resolveFilename(SCOPE_CURRENT_SKIN, "picon_default.png")
					if fileExists(tmp):
						pngname = tmp
					else:
						pngname = resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/picon_default.png")
				self.nameCache["default"] = pngname
		return pngname

	def alternative(self, serviceName):
		def alternativeChannels(service):
			tmp = eServiceCenter.getInstance().list(eServiceReference(service))
			return tmp and tmp.getContent("S", True)
		if serviceName.startswith('1:134:'):
			channels = alternativeChannels(serviceName)
			if channels:
				return channels[0]
		return serviceName

	def findPicon(self, serviceName):
		for path in self.searchPaths:
			pngname = (path % self.path) + serviceName + ".png"
			if fileExists(pngname):
				return pngname
		return ""