# -*- coding: utf-8 -*-

##
## Picon renderer by Gruffy .. some speedups by Ghost
##

from Renderer import Renderer
from enigma import ePixmap, eEnv
from Tools.Directories import fileExists, SCOPE_SKIN_IMAGE, SCOPE_CURRENT_SKIN, resolveFilename
from Components.config import config, ConfigElement
from Tools.PiconResolver import PiconResolver

PICONSPATH_DEFAULT = eEnv.resolve("${datadir}/enigma2")

class mtxPiconAO(Renderer):
	def __init__(self):
		Renderer.__init__(self)

		self.path = "picon"
		self.nameCache = { }
		self.pngname = ""
		config.plugins.InfoBar.PiconsPath.addNotifier(self.pathChanged, initial_call = True, call_on_save_or_cancel = True)

	def applySkin(self, desktop, parent):
		attribs = [ ]
		for (attrib, value) in self.skinAttributes:
			if attrib == "path":
				self.path = value
			else:
				attribs.append((attrib, value))
		self.skinAttributes = attribs
		return Renderer.applySkin(self, desktop, parent)

	GUI_WIDGET = ePixmap

	def postWidgetCreate(self, instance):
		instance.setScale(1)
		instance.setDefaultAnimationEnabled(False)

	def preWidgetRemove(self, instance):
		config.plugins.InfoBar.PiconsPath.removeNotifier(self.pathChanged)

	def changed(self, what):
		if self.instance:
			if what[0] == self.CHANGED_ANIMATED:
				return
			pngname = ""
			sname = self.source.text
			if what[0] != self.CHANGED_CLEAR:
				pngname = PiconResolver.getPngName(sname, self.nameCache, self.findPicon)
			if pngname == "": # no picon for service found, resolve skin default picon
				tmp = resolveFilename(SCOPE_CURRENT_SKIN, "picon_default.png")
				if fileExists(tmp):
					pngname = tmp
				else:
					pngname = resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/picon_default.png")
				self.nameCache["default"] = pngname
			print "[mtxPiconAO] Find picon:", pngname
			if self.pngname != pngname:
				print "[mtxPiconAO] Show picon:", pngname
				self.instance.setPixmapFromFile(pngname)
				self.pngname = pngname

	def pathChanged(self, configElement = None):
		if config.plugins.InfoBar.PiconsPath.value:
			self.piconPath = config.plugins.InfoBar.PiconsPath.value + "/%s/"
		else:
			self.piconPath = PICONSPATH_DEFAULT + "/%s/"
		print "[mtxPiconAO] Picon search path changed: ", self.piconPath
		if hasattr(self, "nameCache"):
			#print "[mtxPiconAO] Picon cache: ", self.nameCache
			self.nameCache.clear()
			self.pngname = ""
			self.changed((self.CHANGED_ALL,))

	def findPicon(self, serviceName):
		print "[mtxPiconAO] Picon search path: ", self.piconPath
		pngname = (self.piconPath % self.path) + serviceName + ".png"
		if fileExists(pngname):
			return pngname
		return ""
