from enigma import eConsoleAppContainer

from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Screens.VirtualKeyBoard import VirtualKeyBoard

from Screens.Setup import SetupSummary
from Components.ConfigList import ConfigList
from Components.config import config, getConfigListEntry, ConfigSelection, ConfigSubsection, ConfigText

from Components.ActionMap import ActionMap
from Components.Label import Label
from Components.Pixmap import Pixmap
from Components.Sources.StaticText import StaticText
from Components.Sources.List import List
from Plugins.Plugin import PluginDescriptor

import string
import sys 
import time
from random import Random 

title=_("Change Root Password")

class ChangePasswdScreen(Screen):
	skin = """
	<screen name="ChangePasswdScreen" position="center,center" size="820,100" title="Change Root Password" >
		<ePixmap pixmap="skin_default/buttons/red.png" position="10,5" size="200,40" alphatest="on" />
		<ePixmap pixmap="skin_default/buttons/green.png" position="210,5" size="200,40" alphatest="on" />
		<ePixmap pixmap="skin_default/buttons/yellow.png" position="410,5" size="200,40" alphatest="on" />
		<ePixmap pixmap="skin_default/buttons/blue.png" position="610,5" size="200,40" alphatest="on" />
		<widget source="key_red" render="Label" position="10,5" size="200,40" zPosition="1" font="Regular;20" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" shadowColor="black" shadowOffset="-2,-2" />
		<widget source="key_green" render="Label" position="210,5" size="200,40" zPosition="1" font="Regular;20" halign="center" valign="center" backgroundColor="#1f771f" transparent="1" shadowColor="black" shadowOffset="-2,-2" />
		<widget source="key_yellow" render="Label" position="410,5" size="200,40" zPosition="1" font="Regular;20" halign="center" valign="center" backgroundColor="#a08500" transparent="1" shadowColor="black" shadowOffset="-2,-2" />
		<widget source="key_blue" render="Label" position="610,5" size="200,40" zPosition="1" font="Regular;20" halign="center" valign="center" backgroundColor="#18188b" transparent="1" shadowColor="black" shadowOffset="-2,-2" />
		<eLabel position="10,50" size="800,1" backgroundColor="grey" />
		<widget name="passwd" position="10,60" size="800,45" scrollbarMode="showOnDemand" />
	</screen>"""

	def __init__(self, session, args = 0):
		Screen.__init__(self, session)
		self.skin = ChangePasswdScreen.skin

		self.user="root"
		self.output_line = ""
		self.list = []
		
		self["passwd"] = ConfigList(self.list)
		self["key_red"] = StaticText(_("Cancel"))
		self["key_green"] = StaticText(_("Set Password"))
		self["key_yellow"] = StaticText(_("new Random"))
		self["key_blue"] = StaticText(_("virt. Keyboard"))

		self["actions"] = ActionMap(["OkCancelActions", "ColorActions"],
				{
						"red": self.close,
						"green": self.SetPasswd,
						"yellow": self.newRandom,
						"blue": self.bluePressed,
						"cancel": self.close
				}, -1)
	
		self.buildList(self.GeneratePassword())

	def newRandom(self):
		self.buildList(self.GeneratePassword())
	
	def buildList(self, password):
		self.password=password
		self.list = []
		self.list.append(getConfigListEntry(_('Enter new Password'), ConfigText(default = self.password, fixed_size = False)))
		self["passwd"].setList(self.list)
		
	def GeneratePassword(self): 
		passwdChars = string.letters + string.digits
		passwdLength = 8
		return ''.join(Random().sample(passwdChars, passwdLength)) 

	def SetPasswd(self):
		print "Changing password for %s to %s" % (self.user,self.password) 
		self.container = eConsoleAppContainer()
		self.appClosed_conn = self.container.appClosed.connect(self.runFinished)
		self.dataAvail_conn = self.container.dataAvail.connect(self.dataAvail)
		self.container.execute("passwd %s" % self.user)

	def dataAvail(self,data):
		self.output_line += data
		while True:
			i = self.output_line.find('\n')
			if i == -1:
				break
			self.processOutputLine(self.output_line[:i+1])
			self.output_line = self.output_line[i+1:]

	def processOutputLine(self,line):
		if line.find('password: '):
			self.container.write("%s\n"%self.password)

	def runFinished(self,retval):
		if retval==0:
			message=_("Sucessfully changed password for root user to: ") + self.password
		else:
			message=_("Unable to change/reset password for root user")
		self.session.open(MessageBox, message , MessageBox.TYPE_ERROR)
		del self.container.dataAvail[:]
		del self.container.appClosed[:]
		del self.container
		self.close()
		
	def bluePressed(self):
		self.session.openWithCallback(self.VirtualKeyBoardTextEntry, VirtualKeyBoard, title = (_("Enter your password here:")), text = self.password)
	
	def VirtualKeyBoardTextEntry(self, callback = None):
		if callback is not None and len(callback):
			self.buildList(callback)

def startChange(menuid):
	if menuid != "system": 
		return [ ]
	return [(title, main, "change_root_passwd", 50)]

def main(session, **kwargs):
	session.open(ChangePasswdScreen)

def Plugins(**kwargs):
	return PluginDescriptor(
		name=title, 
		description=_("Change or reset the root password of your dreambox"),
		where = [PluginDescriptor.WHERE_MENU], fnc = startChange)
	